# Femto NetLinux ARM64 XIP Demo

## What is this?

A demonstration of Linux 6.19 running Execute-In-Place (XIP) on ARM64,
booting with only **1152K of RAM**. The kernel executes directly from
emulated NOR flash, without being copied to RAM first.

This is the result of the Linaro ARM64 XIP patchset:
- **11-patch xip-set**: core ARM64 XIP support
- **9-patch tiny-set**: memory reduction for minimal configurations

## Memory Layout

| Device      | Address      | Contents                          |
|-------------|-------------|-----------------------------------|
| pflash0     | 0x00000000  | XIP kernel (xipImage, ~4.5MB)    |
| pflash1     | 0x04000000  | cramfs root filesystem + busybox  |
| RAM         | 0x40040000  | 1152K (kernel data + stack only)  |

The kernel code runs in-place from pflash0. Only mutable data (stack,
page tables, dynamic allocations) uses RAM. The root filesystem is
cramfs, also accessed directly from flash.

## Requirements

- QEMU with aarch64 system emulation (`qemu-system-aarch64`)
- No cross-compiler or kernel source needed - images are pre-built

## Quick Start

```
tar xzf femto-arm64-xip-6.19.tar.gz
cd femto-arm64-xip
chmod +x boot-xip.sh
./boot-xip.sh
```

You should see the kernel boot and reach a BusyBox shell prompt.

## Files

- `flash-tiny.img` - 64MB pflash0 image containing the XIP kernel
- `flash-cramfs.img` - 64MB pflash1 image containing cramfs root filesystem
- `boot-xip.sh` - QEMU launch script
- `README.md` - this file

## Manual QEMU Command

```
qemu-system-aarch64 \
    -machine virt,gic-version=2 \
    -cpu cortex-a53 \
    -m 1152K \
    -display none \
    -serial stdio \
    -drive if=pflash,file=flash-tiny.img,format=raw,readonly=on,index=0 \
    -drive if=pflash,file=flash-cramfs.img,format=raw,readonly=on,index=1
```

## More Information

- Website: http://www.netlinux.org.uk/nlfs.html
- Linaro ARM64 XIP work: https://linaro.atlassian.net/
