#!/bin/bash
# Femto NetLinux ARM64 XIP Demo
# Boots a v6.19 XIP kernel directly from NOR flash with only 1152K RAM
#
# Usage: ./boot-xip.sh [RAM_SIZE]
#   RAM_SIZE defaults to 1152K (the minimum required)

RAM=${1:-1152K}

echo "Femto NetLinux ARM64 XIP Demo"
echo "Kernel: Linux 6.19 (Execute-In-Place from NOR flash)"
echo "RAM: $RAM"
echo ""

qemu-system-aarch64 \
    -machine virt,gic-version=2 \
    -cpu cortex-a53 \
    -m $RAM \
    -display none \
    -serial stdio \
    -drive if=pflash,file=flash-tiny.img,format=raw,readonly=on,index=0 \
    -drive if=pflash,file=flash-cramfs.img,format=raw,readonly=on,index=1
